# Programowanie sterowane testami w Pythonie. Jak tworzyć skalowalne zestawy testów i aplikacji

To jest archiwum przykładowych fragmentów kodu dla książki [Programowanie sterowane testami w Pythonie. Jak tworzyć skalowalne zestawy testów i aplikacji](https://helion.pl/ksiazki/programowanie-sterowane-testami-w-pythonie-jak-tworzyc-skalowalne-zestawy-testow-i-aplikacji-alessandro-molina,proste.htm), wydanej przez Helion.

**Wykorzystaj Pythona i frameworka pytest do tworzenia zbiorów testów, które będą skalowane razem z potrzebami aplikacji i ich poziomem skomplikowania.**

## O czym jest ta książka?
Programowanie sterowane testami (ang. test-driven development, TDD) to zbiór najlepszych praktyk pomagających programistom w tworzeniu lepiej skalującego się oprogramowania. Pozwalają również na zwiększenie niezawodności oprogramowania dzięki wykorzystaniu automatycznych testów. W tej książce zamierzam pokazać, jak podejście TDD można efektywnie stosować w projektach Pythona.

W książce znalazło się omówienie wielu fascynujących funkcjonalności: 
* Dowiesz się, dlaczego testy mogą ułatwić pracę programiście i poznasz najlepsze praktyki dotyczące definiowania testów.
* Opanujesz pytest, czyli najczęściej stosowany framework Pythona przeznaczony do testowania aplikacji.
* Poznasz najczęściej używane wtyczki frameworka pytest m.in. coverage, flaky, xdist i picked.
* Nauczysz się tworzyć testy funkcjonalne dla aplikacji WSGI wykorzystując do tego bibliotekę webtest.
* Zobaczysz, jak za pomocą frameworka Robot wykonywać testy typu E2E dla aplikacji internetowych

Jeżeli uważasz, że ta książka może Ci się przydać, już dzisiaj sięgnij po swoją [kopię](https://helion.pl/ksiazki/programowanie-sterowane-testami-w-pythonie-jak-tworzyc-skalowalne-zestawy-testow-i-aplikacji-alessandro-molina,proste.htm)!

## Informacje dodatkowe
Wszystkie pliki kodu źródłowego zostały umieszczone w odpowiednich katalogach, np.  Rozdzial01.

Przykładowy fragment kodu przedstawia się następująco:
```
import unittest

class MyTestCase(unittest.TestCase):
    def test_one(self):
        pass
```

**Jak zmaksymalizować korzyści z czytania tej książki?**
To jest książka przeznaczona dla programistów Pythona, którzy chcą rozpocząć stosowanie programowania sterowanego testami. Przyda się również programistom poznającym oferowane przez Pythona narzędzia przeznaczone do testowania kodu. Skorzystają z niej także programiści tworzący aplikacje internetowe za pomocą frameworka Django i Pythona oraz planujący wykorzystanie metodologii TDD i frameworka pytest. Konieczna jest podstawowa wiedza z zakresu programowania w Pythonie.

Jeżeli masz wymienione tutaj oprogramowanie, możesz uruchomić wszystkie przykładowe fragmenty kodu zamieszczone w książce (w rozdziałach od 1. do 12.).

### Oprogramowanie użyte w książce

| Rozdział  | Wymagane oprogramowanie             | Wymagany system operacyjny          |
| --------  | ------------------------------------| ------------------------------------|
| 1-12      | Python 3.9,3.8 lub 3.7              | Windows, Mac OS X i Linux (dowolny) |
| 5-10      | pytest 6.0.2+                       | Windows, Mac OS X i Linux (dowolny) |
| 1-12      | pip 18+                             | Windows, Mac OS X i Linux (dowolny) |
| 1-12      | Google Chrome lub Firefox           | Windows, Mac OS X i Linux (dowolny) |

### Inne podobne pozycje
* Django 3. Praktyczne tworzenie aplikacji sieciowych. Wydanie III [[Helion]](https://helion.pl/ksiazki/django-3-praktyczne-tworzenie-aplikacji-sieciowych-wydanie-iii-antonio-mel,dj3pt3.htm)

* 40 algorytmów, które powinien znać każdy programista. Nauka implementacji algorytmów w Pythonie [[Helion]](https://helion.pl/ksiazki/40-algorytmow-ktore-powinien-znac-kazdy-programista-nauka-implementacji-algorytmow-w-pythonie-imran-ahmad,40algo.htm)

## O autorze
**Alessandro Molina**
jest od 2001 roku programistą Pythona i od zawsze był zainteresowany stosowaniem tego języka jako platformy przeznaczonej do tworzenia aplikacji internetowych. W ciągu ostatnich 10 lat zajmował różne stanowiska, m.in. dyrektora technicznego i kierownika zespołu. Obecnie pracuje nad frameworkami TurboGears2 i Beaker. Opracował framework plikowej pamięci masowej DEPOT i prosty interpreter JavaScriptu dla Pythona nazwany DukPy. Ponadto współpracował nad różnymi projektami Pythona powiązanymi z tworzeniem aplikacji internetowych, m.in. FormEncode, ToscalWidgets i Ming MongoDB ORM.

## Inne książki autora
* [Modern Python Standard Library Cookbook](https://helion.pl/ksiazki/modern-python-standard-library-cookbook-alessandro-molina,e_158k.htm)



